using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for VbecsNumericUpDown.
	/// </summary>
	public class VbecsNumericUpDown : System.Windows.Forms.NumericUpDown
	{
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public VbecsNumericUpDown()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		/// <summary>
		/// Gets or sets the value of the numeric up down control
		/// but does not change the value to be within bounds.
		/// Instead, if the value is outside the min/max range, a
		/// FormatException is thrown.
		/// </summary>
		public new decimal Value
		{
			get
			{
				decimal dValue;
				try
				{
					dValue = Convert.ToDecimal(this.Text);
				}
				catch(FormatException)
				{
					throw new FormatException("Value entered is not a valid number");
				}
				catch(OverflowException)
				{
					throw new FormatException("Value entered is not a valid number");
				}
				//
				if ((dValue >= this.Minimum) && (dValue <= this.Maximum))
					return dValue;
				else
					throw new FormatException(Common.StrRes.SysErrMsg.Common.RangeError("Value entered",this.Minimum,this.Maximum).ResString);
			}
			set
			{
				this.Text = value.ToString();
			}
		}

		/// <summary>
		/// Leave Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnLeave(EventArgs e)
		{
			string formatStr = "0";
			//
			if (this.DecimalPlaces > 0)
			{
				formatStr += ".";
				for (int i = 0; i < this.DecimalPlaces; i++)
					formatStr+="0";
				//
			}
			//
			try
			{
				this.Text = this.Value.ToString(formatStr);
			}
			catch(FormatException)
			{
				if (this.Text == "")
					this.Text = this.Minimum.ToString(formatStr);
			}
			//
			base.OnLeave(e);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="e"></param>
		protected override void OnKeyUp(KeyEventArgs e)
		{
			if (e.KeyCode != Keys.F9)
				Common.Utility.Speak( this.Text );
			base.OnKeyUp(e);
		}
	}
}
